class Proj_Tower_Slith extends Projectile;

var rotator RandRot;
var vector SurfaceNormal;	
var bool bInAir;
var float DotProduct;
var int i;
var Pawn instigator;

event ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.IsA('NoPlayerZone') )
		Self.Destroy();
}

function Timer()
{
	local GreenSmokePuff gsp;

	gsp = Spawn(class'GreenSmokePuff',,,Location+SurfaceNormal*9);
	if (i!=-1) 
	{
		if (LightBrightness > 10) LightBrightness -= 10;
		DrawScale = 0.9*DrawScale;
		gsp.DrawScale = DrawScale*5;
		i++;
		if (i>12) Explode(Location, vect(0,0,0));
	}
}

auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local vector momentum;
	
		if ( Other.IsA('Balloon') )
		{
		if ( Role == ROLE_Authority )
			{
			momentum = MomentumTransfer * Normal(Velocity);
			if ( PBPRI(PlayerPawn(instigator).PlayerReplicationInfo).SlithLevel > 1 )
				{
				Other.TakeDamage( 8, instigator, HitLocation, momentum, 'GlueGun');
				}
			else
				Other.TakeDamage( 8, instigator, HitLocation, momentum, 'Tower');
			}
		Destroy();
		}
	}

	function HitWall( vector HitNormal, actor Wall )
	{
		MakeNoise(0.6);	
		bInAir = False;
		PlaySound(ImpactSound);	
		SurfaceNormal = HitNormal;
		RandRot = rotator(HitNormal);
		RandRot.Roll += 32768;
		SetRotation(RandRot);	
		PlaySound(ImpactSound);		
		SetPhysics(PHYS_None);
		GoToState('OnSurface');
	}

	function BeginState()
	{	
		i=-1;
		if (FRand() < 0.5)
			DrawScale = 0.3 + 0.7 * FRand();
		Velocity = Vector(Rotation) * speed;	
		SetTimer(0.2,True);
		RotationRate.Yaw = Int(200000 * FRand()) - 100000;
		RotationRate.Pitch = Int(FRand() * (200000 - Abs(RotationRate.Yaw))) 
								- (100000 - Abs(RotationRate.Yaw)/2);
		LoopAnim('Flying',0.4);
		SurfaceNormal = Vect(0,0,0);
		bInAir=True;
		PlaySound(SpawnSound);
		if( Region.zone.bWaterZone )
			Velocity=Velocity*0.7;
	}
}

state OnSurface
{
	function ProcessTouch (Actor Other, vector HitLocation)
	{
		Explode(HitLocation, vect(0,0,0));
	}
Begin:
	i=0;
	PlayAnim('Hit');
	FinishAnim();
	DotProduct = SurfaceNormal dot vect(0,0,-1);
	If( DotProduct > 0.7 )
	{
		PlayAnim('Drip',0.1);
		FinishAnim();
	}
	else if (DotProduct > -0.5)
	{
		PlayAnim('Slide',0.2);
		Finishanim();
	}
}

defaultproperties
{
     speed=400.000000
     Damage=8.000000
     MomentumTransfer=20
     SpawnSound=Sound'UnrealShare.Slith.SliSpawn'
     ImpactSound=Sound'UnrealShare.Slith.SliImpact'
     bNetTemporary=False
     Mesh=LodMesh'UnrealShare.ngel'
     DrawScale=0.500000
     bUnlit=True
     CollisionRadius=6.000000
     CollisionHeight=4.000000
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=101
     LightHue=88
     LightSaturation=9
     LightRadius=4
     bBounce=True
     bFixedRotationDir=True
}
